<?php
if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'EDD_nikSum_Gateway' ) ) :

class EDD_nikSum_Gateway
{
	public $keyname;

	public function __construct()
	{
		$this->keyname = 'niksum';

		add_filter( 'edd_payment_gateways', array( $this, 'add' ) );
		add_action( $this->format( 'edd_{key}_cc_form' ), array( $this, 'cc_form' ) );
		add_action( $this->format( 'edd_gateway_{key}' ), array( $this, 'process' ) );
		add_action( $this->format( 'edd_verify_{key}' ), array( $this, 'verify' ) );
		add_filter( 'edd_settings_gateways', array( $this, 'settings' ) );

		add_action( 'edd_payment_receipt_after', array( $this, 'receipt' ) );

		add_action( 'init', array( $this, 'listen' ) );
	}

	public function add( $gateways )
	{
		global $edd_options;

		$gateways[ $this->keyname ] = array(
			'checkout_label' 		=>	isset( $edd_options['niksum_label'] ) ? $edd_options['niksum_label'] : 'پرداخت آنلاین درگاه پرداخت نیک سام',
			'admin_label' 			=>	'درگاه پرداخت نیک سام'
		);

		return $gateways;
	}

	public function cc_form()
	{
		return;
	}

	public function process( $purchase_data )
	{
		global $edd_options;

		@session_start();

		$payment = $this->insert_payment( $purchase_data );

		if ( $payment )
		{
			$amount = intval( $purchase_data['price'] ) / 10;
			if ( edd_get_currency() == 'IRT' )
				$amount = $amount * 10; // Return back to original one.

			$MerchantID 	= (isset( $edd_options[ $this->keyname . '_merchant' ] ) ? $edd_options[ $this->keyname . '_merchant' ] : '');
			$InvoiceID 		= $payment;
			$Description 	= 'پرداخت شماره #' . $payment.' | '.$purchase_data['user_info']['first_name'].' '.$purchase_data['user_info']['last_name'];
			$Email 			= $purchase_data['user_info']['email'];
			$Mobile 		= "";
			$CallbackURL 	= add_query_arg( 'verify_' . $this->keyname, '1', get_permalink( $edd_options['success_page'] ) );

			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, 'https://niksum.ir/webservice/rest/PaymentRequest');
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
			curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$amount}&InvoiceID={$InvoiceID}&Description={$Description}&Email={$Email}&Mobile={$Mobile}&CallbackURL=". urlencode($CallbackURL));
			curl_setopt($curl, CURLOPT_TIMEOUT, 30);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			$curl_exec = curl_exec($curl);
			curl_close($curl);

			$result = json_decode($curl_exec);

			if (isset($result->Status) && $result->Status == 100)
			{
				edd_insert_payment_note( $payment, 'کد تراکنش ‌درگاه پرداخت نیک سام : ' . $result->Authority );
				edd_update_payment_meta( $payment, 'niksum_authority', $result->Authority );

				$_SESSION['zp_payment'] = $payment;

				wp_redirect( $result->PaymentUrl );

				@header("Location: {$result->PaymentUrl}");
			} else {
				$PaymentError = (isset($result->Status) && $result->Status != "") ? $result->Status : 103;

				edd_insert_payment_note( $payment, 'کد خطا: ' . $PaymentError );
				edd_insert_payment_note( $payment, 'علت خطا: ' . $this->error_reason( $PaymentError ) );
				edd_update_payment_status( $payment, 'failed' );

				edd_set_error( 'niksum_connect_error', 'در اتصال به درگاه مشکلی پیش آمد. علت: ' . $this->error_reason( $PaymentError ) );

				edd_send_back_to_checkout();
			}
		} else {
			edd_send_back_to_checkout( '?payment-mode=' . $purchase_data['post_data']['edd-gateway'] );
		}
	}

	public function verify()
	{
		global $edd_options;

		if ( isset( $_POST['Authority'] ) )
		{
			$authority 	= (isset($_POST['Authority']) && $_POST['Authority'] != "") ? sanitize_text_field( $_POST['Authority'] ) : "";
			$InvoiceID 	= (isset($_POST['InvoiceID']) && $_POST['InvoiceID'] != "") ? $_POST['InvoiceID'] : "";

			@ session_start();

			$payment = edd_get_payment( $_SESSION['zp_payment'] );

			unset( $_SESSION['zp_payment'] );

			if ( ! $payment )
			{
				wp_die( 'رکورد پرداخت موردنظر وجود ندارد!' );
			}

			if ( $payment->status == 'complete' )
			{
				return false;
			}

			$amount = intval( edd_get_payment_amount( $payment->ID ) ) / 10;

			if ( 'IRT' === edd_get_currency() ) {
				$amount = $amount * 10;
			}

			$merchant = ( isset( $edd_options[ $this->keyname . '_merchant' ] ) ? $edd_options[ $this->keyname . '_merchant' ] : '' );

			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, 'https://niksum.ir/webservice/rest/PaymentVerification');
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
			curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$merchant}&Amount={$amount}&Authority={$authority}");
			curl_setopt($curl, CURLOPT_TIMEOUT, 30);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			$curl_exec = curl_exec($curl);
			curl_close($curl);

			$result = json_decode($curl_exec);

			edd_empty_cart();

			if ( version_compare( EDD_VERSION, '2.1', '>=' ) ) {
				edd_set_payment_transaction_id( $payment->ID, $authority );
			}

			if (isset($result->Status) && $result->Status == 100)
			{				
				edd_insert_payment_note( $payment->ID, 'شماره تراکنش بانکی: ' . $result->RefID );
				edd_update_payment_meta( $payment->ID, 'niksum_refid', $result->RefID );
				edd_update_payment_status( $payment->ID, 'publish' );
				edd_send_to_success_page();
			} else {				
				edd_update_payment_status( $payment->ID, 'failed' );
				wp_redirect( get_permalink( $edd_options['failure_page'] ) );

				exit;
			}
		}
	}

	public function receipt( $payment )
	{
		$refid = edd_get_payment_meta( $payment->ID, 'niksum_refid' );

		if ( $refid ) {
			echo '<tr class="niksum-ref-id-row ezp-field miladworkshop-dev"><td><strong>شماره تراکنش بانکی:</strong></td><td>' . $refid . '</td></tr>';
		}
	}

	public function settings( $settings )
	{
		return array_merge( $settings, array(
			$this->keyname . '_header' 		=>	array(
				'id' 			=>	$this->keyname . '_header',
				'type' 			=>	'header',
				'name' 			=>	'<strong>درگاه درگاه پرداخت نیک سام</strong> توسط <a href="https://miladworkshop.ir" target="_blank">Milad Maldar</a>'
			),
			$this->keyname . '_merchant' 		=>	array(
				'id' 			=>	$this->keyname . '_merchant',
				'name' 			=>	'مرچنت‌کد',
				'type' 			=>	'text',
				'size' 			=>	'regular'
			),
			$this->keyname . '_label' 	=>	array(
				'id' 			=>	$this->keyname . '_label',
				'name' 			=>	'نام درگاه در صفحه پرداخت',
				'type' 			=>	'text',
				'size' 			=>	'regular',
				'std' 			=>	'پرداخت آنلاین درگاه پرداخت نیک سام'
			)
		) );
	}

	private function format( $string )
	{
		return str_replace( '{key}', $this->keyname, $string );
	}

	private function insert_payment( $purchase_data )
	{
		global $edd_options;

		$payment_data = array(
			'price' 		=> $purchase_data['price'],
			'date' 			=> $purchase_data['date'],
			'user_email' 	=> $purchase_data['user_email'],
			'purchase_key' 	=> $purchase_data['purchase_key'],
			'currency' 		=> $edd_options['currency'],
			'downloads' 	=> $purchase_data['downloads'],
			'user_info' 	=> $purchase_data['user_info'],
			'cart_details' 	=> $purchase_data['cart_details'],
			'status' 		=> 'pending'
		);

		// record the pending payment
		$payment = edd_insert_payment( $payment_data );

		return $payment;
	}

	public function listen()
	{
		if ( isset( $_GET[ 'verify_' . $this->keyname ] ) && $_GET[ 'verify_' . $this->keyname ] )
		{
			do_action( 'edd_verify_' . $this->keyname );
		}
	}

	public function error_reason( $error_id )
	{
		$message = 'خطای ناشناخته';

		switch ( $error_id )
		{
			case '-1':
				$message = 'درخواست باید از طریق متد ارسال شود';
				break;
			case '-2':
				$message = 'مقداری برای MerchantID ارسال نشده است';
				break;
			case '-3':
				$message = 'مقداری برای Amount ارسال نشده است';
				break;
			case '-4':
				$message = 'مقداری برای CallbackURL ارسال نشده است';
				break;
			case '-5':
				$message = 'حداقل مبلغ قابل پرداخت 100 تومان می‌باشد';
				break;
			case '-6':
				$message = 'MerchantID وارد شده در سیستم یافت نشد';
				break;
			case '-7':
				$message = 'MerchantID وارد شده فعال نیست';
				break;
			case '-8':
				$message = 'اکانت پذیرنده تجاری نیست, لذا امکان استفاده از وبسرویس را ندارید';
				break;
			case '-9':
				$message = 'IP معتبر نیست';
				break;
			case '-10':
				$message = 'آدرس بازگشتی با آدرس درگاه پرداخت ثبت شده همخوانی ندارد';
				break;
			case '-11':
				$message = 'خطای در وب سرویس - ایجاد تراکنش با خطا مواجه شد';
				break;
			case '-12':
				$message = 'مقدار Authority ارسالی معتبر نیست - تراکنش یافت نشد';
				break;
			case '-13':
				$message = 'مقداری برای Authority ارسال نشده است';
				break;
			case '-14':
				$message = 'اطلاعات تراکنش یافت نشد, مقدار Authority را بررسی کرده و صحیح بودن آن اطمینان حاصل کنید';
				break;
			case '-15':
				$message = 'تراکنش پرداخت نشده است';
				break;
			case '-16':
				$message = 'مبلغ ارسال شده با مبلغ تراکنش یکسان نیست, مقدار Amount را بررسی کرده و نسبت به صحت آن اطمینان حاصل کنید';
				break;
			case '-17':
				$message = 'دسترسی شما به این تراکنش رد شد, Authority این تراکنش برای MerchantID شما ثبت نشده است';
				break;
			case '-18':
				$message = 'پرداخت تراکنش با موفقیت انجام شده است, اما در بروزرسانی کیف پول پذیرنده مشکلی پیش آمده است';
				break;
			case '-19':
				$message = 'وضعیت تراکنش نامشخص است';
				break;
			case '100':
				$message = 'عمليات با موفقيت انجام گرديده است';
				break;
			case '101':
				$message = 'عمليات پرداخت موفق بوده و قبلا  PaymentVerification تراكنش انجام شده است.';
			break;
			case '102':
				$message = 'تراکنش توسط کاربر لغو شد.';
			break;
			case '103':
				$message = 'تراکنش توسط کاربر لغو شد.';
			break;
		}

		return $message;
	}
}

endif;

new EDD_nikSum_Gateway;